unit MbServiceDb01;
(*
   ========================================================================
    MicroBase.
          .
   ========================================================================
     :
   1)         .
   2)        
   3)  ( )      .
   4)      .
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface
uses //  
     SysUtils, Dialogs, Controls,
     //    Microbase
     MbMainData01,
     //   Microbase     
     MbFileTools01;

//------------------------------------------------------------------------
//       , 
// ,   
function TestDefaultBaseFileName (RqAppDirectory : string) : boolean;
//------------------------------------------------------------------------
//  ( )    
function SaveDBAs(RqMicroBase    : TMicroBase;
                  RqSaveDialog   : TSaveDialog;
                  RqAppDirectory : string) : string;
//------------------------------------------------------------------------
//      c  
function CreateNewDBAs (RqSaveDialog   : TSaveDialog;
                        RqAppDirectory : string) : string;

// ==========================================================================
// ==========================================================================

implementation

// ==========================================================================
//       
// ==========================================================================
// 04.02.2013
//       
//   : TestMicroBaseDirectory ('D:\ImgTools\Filters');
function TestMicroBaseDirectory (RqDirectoryName : string) : boolean;
begin
  Result := False;
  if not DirectoryExists(RqDirectoryName)
  then begin
    try
      CreateDir(RqDirectoryName);
      Result := True;
    except
      MessageDlg('MicroBase :       *.fdb : '
                  + #13#10 + RqDirectoryName, mtError, [mbOk], 0);
    end;
  end
  else Result := True;
end;
//------------------------------------------------------------------------
// 04.02.2013
//    () 
//   : CreateNewMicroBase('D:\ImgTools\Filters\FilterBase.fdb');
function CreateNewMicroBase(RqFileName : string) : boolean;
var FileHandle: Integer;
begin
  Result := False;
  if not FileExists(RqFileName)
  then begin
     try
        FileHandle := FileCreate(RqFileName);
        FileClose(FileHandle);
        Result := True;
     except
        MessageDlg('MicroBase :       : '
                    + #13#10 + RqFileName, mtError, [mbOk], 0);
     end;
  end;
end;
//------------------------------------------------------------------------
// 04.02.2013
//       , 
// ,   
function TestDefaultBaseFileName (RqAppDirectory : string) : boolean;
var WStr : string;
begin
  Result := False;
  DefaultFileName := '';   //      
  //      
  WStr := RqAppDirectory;
  WStr := WStr + '\' + DefaultBaseDirectory;
  if TestMicroBaseDirectory (WStr)
  then begin
    //     
    WStr := WStr + '\' + DefaultBaseFileName;
    if not FileExists(WStr)
    then begin
       //    () 
       if CreateNewMicroBase(WStr)
       then DefaultFileName := WStr  //  
       else DefaultFileName := '';   //     
    end
    else DefaultFileName := WStr;    //  
  end;
  //      
  WorkerFileName  := DefaultFileName;
  if DefaultFileName <> '' then Result := True;
end;

// ==========================================================================
// ,      
// ==========================================================================
// 04.02.2013
//    MicroBase
function MicroBaseOK(RqMicroBase : TMicroBase) : boolean;
begin
  Result := False;
  //    RqMicroBase
  if not Assigned(RqMicroBase) then Exit;
  //     ,  
  if not RqMicroBase.OpenOk then Exit;
  //      
  Result := True;
end;
//------------------------------------------------------------------------
// 04.02.2013
//       SaveDialog
function NormalizeMbFileName (RqFileName : string) : string;
var FileExt : string;
begin
   Result := RqFileName;
   FileExt  := UpperCase(ExtractFileExt(RqFileName));
   //     ,    
   if not (FileExt = '.FDB')
   then Result := RqFileName + '.fdb';
end;

//------------------------------------------------------------------------
// 04.02.2013
//  ( )    
function SaveDBAs(RqMicroBase    : TMicroBase;
                  RqSaveDialog   : TSaveDialog;
                  RqAppDirectory : string) : string;
//
var SaveFHandle : Integer;   //  
    PDat        : pointer;   //      MicroBase
    Indx        : integer;   //   
    RpOK        : boolean;   //      
    WName       : string;    //  
begin
  Result := '';
  //    MicroBase
  if not MicroBaseOK(RqMicroBase) then Exit;
   //    
  RqSaveDialog.InitialDir := RqAppDirectory + '\' + DefaultBaseDirectory;
  //     
  RqSaveDialog.Filter := 'Microbase files (*.fdb)|*.FDB';
  //  
  if RqSaveDialog.Execute
  then begin
     WName := RqSaveDialog.FileName;
     WName := NormalizeMbFileName(WName);
     //         
     if FileExists(WName) and (not (WName = WorkerFileName))
     then begin
        RpOK  := (MessageDlg('   : '
                + ExtractFileName(WName)
                + #13#10
                + '  ! ?',
                mtConfirmation, [mbYes, mbNo], 0) = mrYes);
        //    
        if not RpOK then Exit;
     end;
     //     
     if not (WName = WorkerFileName)
     then begin
        //   
        SaveFHandle := FileCreate(WName);
        // ---------------------------------------
        //     
        // ---------------------------------------
        //     
        Indx := 0;
        PDat := RqMicroBase.ReadRecFromFile(Indx);
        //    
        while PDat <> nil
        do begin
           //   
           if (RqMicroBase.RecStat = rsDataRec) //   
           then begin
              //      
              //  FileWrite (unit SysUtils) 
              //   ,  
              //    (  )
              FileWrite(SaveFHandle,
              RqMicroBase.pRecBuf^,
              RqMicroBase.RecSize);
           end;
           //      
           Indx := Indx + 1;
           PDat := RqMicroBase.ReadRecFromFile(Indx);
        end;
        FileClose(SaveFHandle);
        // ---------------------------------------
        //  
        Result := WName;
     end
     else begin
        MessageDlg('     '
                 + #13#10
                 + '     ',
                 mtError, [mbOk], 0);
     end;
  end;
end;
//------------------------------------------------------------------------
// 04.02.2013
//      c  
function CreateNewDBAs (RqSaveDialog   : TSaveDialog;
                        RqAppDirectory : string) : string;
var RpOK  : boolean;   //      
    WName : string;    //  
begin
  Result := '';
   //    
  RqSaveDialog.InitialDir := RqAppDirectory + '\' + DefaultBaseDirectory;
  //     
  RqSaveDialog.Filter := 'Microbase files (*.FDb)|*.FDB';
  if RqSaveDialog.Execute
  then begin
     WName := RqSaveDialog.FileName;
     WName := NormalizeMbFileName(WName);
     //         
     if FileExists(WName) and
       (not (WName = WorkerFileName))
     then begin
        RpOK  := (MessageDlg('   : '
                + ExtractFileName(WName)
                + #13#10
                + '  ! ?',
                mtConfirmation, [mbYes, mbNo], 0) = mrYes);
        if RpOK //   
        then DeleteFile(WName)
        else Exit; //    
     end;
     //     
     if not (WName = WorkerFileName)
     then begin
        //   
        if CreateNewMicroBase(WName)
        then Result := WName;
     end
     else begin
        MessageDlg('   '
                 + #13#10
                 + '     ',
                 mtError, [mbOk], 0);
     end;
  end;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================

end.
